/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k.indication.server;

import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCEvent;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscription;
import com.ibm.hsc.cim.provider.rs6k.indication.server.HSCConnListener;
import com.ibm.hsc.cim.provider.rs6k.indication.server.HSCListener;
import com.ibm.hsc.cim.provider.rs6k.indication.server.HSCTimeoutMonitor;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.rep.RObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;

public class HSCEventIndicationMgr
extends Thread {
    public static HSCEventIndicationMgr mInstance = null;
    protected long mCreationTime = 0L;
    protected Vector mListeners;
    protected Hashtable mHandlers;
    protected Vector mAuthKeys = null;
    private boolean mTestOnly = false;
    private Hashtable mCltInfo = new Hashtable();

    public HSCEventIndicationMgr(int n) {
        System.out.println("created HSCEventIndicationMgr");
        this.mListeners = new Vector();
        this.mHandlers = new Hashtable();
        HSCConnListener hSCConnListener = new HSCConnListener(this, n);
        this.mAuthKeys = new Vector();
        this.mCreationTime = System.currentTimeMillis();
        hSCConnListener.start();
        this.start();
        HSCConnListener hSCConnListener2 = new HSCConnListener(this, 9197);
        hSCConnListener2.start();
        new HSCTimeoutMonitor(this.mListeners).start();
    }

    private void setTestOnly() {
        this.mTestOnly = true;
    }

    public void addListenerSite(HSCListener hSCListener) {
        System.out.println("add listener");
        this.mListeners.addElement(hSCListener);
    }

    public void subscribe(HSCSubscription hSCSubscription, HSCListener hSCListener) {
        String string = hSCListener.subscribe(hSCSubscription);
        if (string == null) {
            return;
        }
        Vector<HSCListener> vector = (Vector<HSCListener>)this.mHandlers.get(string);
        if (vector == null) {
            vector = new Vector<HSCListener>();
            this.mHandlers.put(string, vector);
        }
        if (vector.indexOf(hSCListener) == -1) {
            vector.addElement(hSCListener);
        }
    }

    public void unsubscribe(HSCSubscription hSCSubscription, HSCListener hSCListener) {
        String string = null;
        if (hSCSubscription != null) {
            string = hSCListener.subscribe(hSCSubscription);
            if (string == null) {
                return;
            }
            this.unsubscribeEvt(string, hSCListener);
        } else {
            Vector vector = hSCListener.getEventKeys();
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.elementAt(n);
                this.unsubscribeEvt(string, hSCListener);
                ++n;
            }
            this.mListeners.removeElement(hSCListener);
            String string2 = hSCListener.getAuthKey();
            if (string2 != null) {
                this.mCltInfo.remove(string2);
                this.mAuthKeys.remove(string2);
            }
        }
    }

    private void unsubscribeEvt(String string, HSCListener hSCListener) {
        Vector vector = (Vector)this.mHandlers.get(string);
        vector.removeElement(hSCListener);
        if (vector.size() == 0) {
            this.mHandlers.remove(string);
        }
    }

    public void handleEvent(int n, String string, Object object, Object object2, long l) {
        HSCEvent hSCEvent = new HSCEvent(n, string, object, object2, l);
        this.handleEvent(hSCEvent);
    }

    public void handleEvent(HSCEvent hSCEvent) {
        String string = hSCEvent.getEventKey();
        Vector vector = (Vector)this.mHandlers.get(string);
        if (vector != null && vector.size() > 0) {
            com.ibm.hsc.indication.client.HSCEvent hSCEvent2 = null;
            int n = 0;
            while (n < vector.size()) {
                HSCListener hSCListener = (HSCListener)vector.elementAt(n);
                if (hSCListener.getPort() == 9197) {
                    if (hSCEvent2 == null) {
                        hSCEvent2 = this.getMcpEvent(hSCEvent);
                    }
                    hSCListener.deliverEvent(hSCEvent2);
                } else {
                    hSCListener.deliverEvent(hSCEvent);
                }
                ++n;
            }
        }
    }

    private com.ibm.hsc.indication.client.HSCEvent getMcpEvent(HSCEvent hSCEvent) {
        return new com.ibm.hsc.indication.client.HSCEvent(hSCEvent.getEventType(), hSCEvent.getObjectType(), this.getRObject(hSCEvent.getOldObject()), this.getRObject(hSCEvent.getNewObject()), hSCEvent.getTimestamp());
    }

    private Object getRObject(Object object) {
        try {
            if (object instanceof CIMInstance) {
                return new RObject("root/ibmhscV3_2", (CIMInstance)object);
            }
            return object;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void run() {
        while (true) {
            boolean bl = false;
            int n = 0;
            while (n < this.mListeners.size()) {
                block9: {
                    HSCListener hSCListener = (HSCListener)this.mListeners.elementAt(n);
                    try {
                        if (hSCListener.isNeedClose()) {
                            System.out.println("Client is down");
                            this.unsubscribe(null, hSCListener);
                            hSCListener.close();
                            bl = true;
                            break;
                        }
                        HSCSubscription hSCSubscription = hSCListener.readSubscription();
                        if (hSCSubscription == null || !this.securityCheck(hSCSubscription)) break block9;
                        System.out.println("authenticated");
                        if (hSCSubscription.isSubscription()) {
                            this.subscribe(hSCSubscription, hSCListener);
                        } else {
                            this.unsubscribe(hSCSubscription, hSCListener);
                        }
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.out);
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._IndicationClassLogInfo);
                        this.unsubscribe(null, hSCListener);
                        hSCListener.close();
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
            if (bl) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private boolean securityCheck(HSCSubscription hSCSubscription) {
        if (this.mTestOnly) {
            return true;
        }
        return this.mAuthKeys.indexOf(hSCSubscription.getAuthKey()) != -1;
    }

    public synchronized String getAuthKey(String string, long l, String string2) {
        String string3 = this.createAuthKey(string, l);
        if (string3 == null) {
            return "";
        }
        int n = this.mAuthKeys.indexOf(string3);
        if (this.mAuthKeys.indexOf(string3) == -1) {
            this.mAuthKeys.addElement(string3);
            string2 = "hostName: " + string + "\nClient CreationTime: " + new Timestamp(l) + "\n" + string2;
            this.mCltInfo.put(string3, string2);
        }
        return string3;
    }

    private String createAuthKey(String string, long l) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress() + "." + this.mCreationTime + "." + l;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public boolean eventHasSubscription(int n) {
        Enumeration enumeration = this.mHandlers.keys();
        String string = "" + n + "-";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static synchronized HSCEventIndicationMgr getInstance() {
        if (mInstance == null) {
            mInstance = new HSCEventIndicationMgr(-1);
        }
        return mInstance;
    }

    public void printStatus() {
        System.out.println("-------- Start Print Indication Server Status .......");
        int n = 0;
        while (n < this.mListeners.size()) {
            HSCListener hSCListener = (HSCListener)this.mListeners.elementAt(n);
            System.out.println("-------- Begin Indication Listener Status");
            hSCListener.printStatus();
            String string = hSCListener.getAuthKey();
            if (string != null) {
                String string2 = (String)this.mCltInfo.get(string);
                System.out.println("Client Info: " + string2);
            }
            System.out.println("-------- End Indication Listener Status");
            ++n;
        }
        System.out.println("-------- End Print Indication Server Status --------------------");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage:");
            System.out.println("java -Djavax.net.ssl.keyStore=/usr/websm/codebase/SM.prikr -Djavax.net.ssl.keyStorePassword=defp -DcimomConfigFile=/opt/hsc/data/cimomcfg.properties com.ibm.hsc.cim.provider.rs6k.indication.server.HSCEventIndicationMgr server_port event_source_object_type {event_types}");
            return;
        }
        try {
            HSCEventIndicationMgr hSCEventIndicationMgr = new HSCEventIndicationMgr(Integer.parseInt(stringArray[0]));
            hSCEventIndicationMgr.setTestOnly();
            long l = 0L;
            while (true) {
                int n = 2;
                while (n < stringArray.length) {
                    hSCEventIndicationMgr.handleEvent(Integer.parseInt(stringArray[n]), stringArray[1], "oldstring***************************************************************************************************************" + l, "newstring***************************************************************************************************************************************************************" + l, System.currentTimeMillis());
                    ++n;
                }
                if (++l % 1000L != 0L) continue;
                System.gc();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._IndicationClassLogInfo);
            return;
        }
    }
}

